<?php
define('CHAT_FILE','chat.txt');
define('UPLOAD_DIR','uploads/');

if(!file_exists(UPLOAD_DIR)) mkdir(UPLOAD_DIR,0777,true);

// حذف پیام
if(isset($_POST['delete']) && isset($_POST['user'])){
    $user = strip_tags($_POST['user']);
    $msgIndex = intval($_POST['delete']);
    $data = json_decode(file_get_contents(CHAT_FILE),true) ?: [];
    if(isset($data[$msgIndex]) && $data[$msgIndex]['user']===$user){
        // حذف فایل مرتبط
        if(isset($data[$msgIndex]['file']) && file_exists($data[$msgIndex]['file'])){
            unlink($data[$msgIndex]['file']);
        }
        array_splice($data,$msgIndex,1);
        file_put_contents(CHAT_FILE,json_encode($data));
    }
    exit;
}

// ارسال پیام یا فایل
if(isset($_POST['user'])){
    $user = strip_tags($_POST['user']);
    $msg = isset($_POST['message']) ? strip_tags($_POST['message']) : '';
    $filePath = '';

    if(isset($_FILES['file']) && $_FILES['file']['error']==0){
        $ext = pathinfo($_FILES['file']['name'], PATHINFO_EXTENSION);
        $filePath = UPLOAD_DIR.time().'_'.basename($_FILES['file']['name']);
        move_uploaded_file($_FILES['file']['tmp_name'],$filePath);
    }

    $data = json_decode(file_get_contents(CHAT_FILE),true) ?: [];
    if($msg || $filePath){
        $data[] = [
            "user"=>$user,
            "message"=>$msg,
            "file"=>$filePath,
            "time"=>date("H:i")
        ];
        file_put_contents(CHAT_FILE,json_encode($data));
    }
    exit;
}

// دریافت پیام‌ها
if(isset($_GET['get'])){
    echo file_get_contents(CHAT_FILE);
    exit;
}
?>
<!DOCTYPE html>
<html lang="fa">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1,maximum-scale=1,user-scalable=no,viewport-fit=cover">
<title>چت‌روم حرفه‌ای</title>
<style>
body{font-family:'Tahoma',sans-serif;background:linear-gradient(135deg,#74ebd5 0%,#ACB6E5 100%);direction:rtl;margin:0;padding:0;display:flex;flex-direction:column;height:100vh;overflow:hidden}
#loginBox,#chatBox{max-width:600px;margin:auto;background:rgba(255,255,255,0.95);border-radius:12px;box-shadow:0 4px 20px rgba(0,0,0,0.2);padding:20px;box-sizing:border-box}
#loginBox{text-align:center;margin:auto}
#loginBox input{padding:15px;width:80%;font-size:18px;border:1px solid #ccc;border-radius:8px;box-sizing:border-box;transition:border-color .3s}
#loginBox input:focus{border-color:#4caf50;outline:none}
#loginBox button{padding:15px 30px;margin-top:15px;background:#4caf50;border:none;color:white;border-radius:8px;cursor:pointer;font-size:18px;transition:background-color .3s}
#loginBox button:hover{background:#45a049}
#chatBox{display:none;flex-direction:column;height:100%;padding-bottom:env(safe-area-inset-bottom);overflow-y:auto;-webkit-overflow-scrolling:touch}
#chatMessages{flex-grow:1;overflow-y:auto;border:1px solid #ddd;padding:15px;border-radius:12px;background:#fff;word-break:break-word;box-shadow:inset 0 0 10px rgba(0,0,0,.1);margin-bottom:10px}
.message{margin-bottom:12px;padding:14px 22px;background:#ffffffcc;border-radius:20px;position:relative;max-width:80%;word-wrap:break-word;box-shadow:0 4px 12px rgba(0,0,0,.12);border:1px solid #d1d1d1;transition:background-color .3s}
.message:hover{background:#f1f1f1cc}
.message.me{background:#dcf8c6cc;margin-left:auto;border-color:#a1d99b;box-shadow:0 4px 12px rgba(0,100,0,.15)}
.message .user{font-weight:bold;margin-bottom:6px;font-size:14px;color:#333}
.message .time{font-size:11px;color:#555;position:absolute;bottom:6px;left:12px}
.delete-btn{position:absolute;top:6px;right:12px;color:#c00;cursor:pointer;font-weight:bold;user-select:none;font-size:18px;transition:color .3s}
.delete-btn:hover{color:#a00}
#inputArea{display:flex;gap:8px;flex-wrap:wrap;margin-top:10px}
#messageInput{flex-grow:1;padding:15px 20px;font-size:18px;border-radius:30px;border:1px solid #ccc;box-sizing:border-box;transition:border-color .3s}
#messageInput:focus{border-color:#4caf50;outline:none}
#fileInput{border-radius:30px;padding:0 12px}
#sendBtn{background:#4caf50;border:none;color:white;font-weight:bold;border-radius:30px;padding:15px 30px;cursor:pointer;font-size:18px;transition:background-color .3s}
#sendBtn:hover{background:#45a049}
#emojiPicker{text-align:center;margin-top:15px}
#emojiPicker span{font-size:28px;cursor:pointer;margin:0 8px;user-select:none;transition:transform .2s}
#emojiPicker span:hover{transform:scale(1.3)}
@media(max-width:640px){#loginBox,#chatBox{width:95%;padding:15px}#loginBox input,#loginBox button{width:100%;padding:14px;font-size:16px}#messageInput{font-size:16px;padding:12px 15px}#sendBtn{padding:12px 20px;font-size:16px}#emojiPicker span{font-size:24px;margin:0 6px}#inputArea{flex-direction:column}#fileInput{width:100%}}
</style>
</head>
<body>

<div id="loginBox">
<h2>ورود به چت‌روم</h2>
<input type="text" id="username" placeholder="نام کاربری...">
<br>
<button onclick="login()">ورود</button>
</div>

<div id="chatBox">
<div id="chatMessages"></div>
<div id="inputArea">
<input type="text" id="messageInput" placeholder="پیام خود را بنویسید...">
<input type="file" id="fileInput">
<button id="sendBtn" onclick="sendMessage()">ارسال</button>
</div>
<div id="emojiPicker">
<span onclick="addEmoji('😊')">😊</span>
<span onclick="addEmoji('😂')">😂</span>
<span onclick="addEmoji('👍')">👍</span>
<span onclick="addEmoji('❤️')">❤️</span>
<span onclick="addEmoji('🔥')">🔥</span>
<span onclick="addEmoji('😢')">😢</span>
<span onclick="addEmoji('🎉')">🎉</span>
</div>
</div>

<script>
let username='';

function login(){
    const input=document.getElementById('username');
    const val=input.value.trim();
    if(!val) return alert('نام کاربری را وارد کنید');
    username=val;
    document.getElementById('loginBox').remove();
    document.getElementById('chatBox').style.display='flex';
    loadMessages();
    setInterval(loadMessages,3000);
}

function addEmoji(e){const i=document.getElementById('messageInput');i.value+=e;i.focus();}

function sendMessage(){
    const msgInput=document.getElementById('messageInput');
    const fileInput=document.getElementById('fileInput');
    const msg=msgInput.value.trim();
    if(!msg && !fileInput.files[0]) return;

    const formData=new FormData();
    formData.append('user',username);
    if(msg) formData.append('message',msg);
    if(fileInput.files[0]) formData.append('file',fileInput.files[0]);

    fetch('',{method:'POST',body:formData}).then(()=>{ msgInput.value=''; fileInput.value=''; loadMessages(); });
}

function deleteMessage(idx){
    if(!confirm('آیا می‌خواهید این پیام را حذف کنید؟')) return;
    fetch('',{method:'POST',headers:{'Content-Type':'application/x-www-form-urlencoded'},body:`user=${encodeURIComponent(username)}&delete=${idx}`}).then(()=>loadMessages());
}

function loadMessages(){
    fetch('?get=1').then(res=>res.json()).then(data=>{
        const container=document.getElementById('chatMessages');
        container.innerHTML='';
        data.forEach((msg,idx)=>{
            const div=document.createElement('div');
            div.className='message'+(msg.user===username?' me':'');
            const fileHtml=msg.file?`<div><a class="file-link" href="${msg.file}" target="_blank">فایل: ${msg.file.split('/').pop()}</a></div>`:'';
            div.innerHTML=`<div class="user">${msg.user}</div><div class="text">${msg.message}</div>${fileHtml}<div class="time">${msg.time}</div>${msg.user===username?`<div class="delete-btn" onclick="deleteMessage(${idx})">×</div>`:''}`;
            container.appendChild(div);
        });
        container.scrollTop=container.scrollHeight;
    });
}

document.getElementById('messageInput').addEventListener('keydown',function(e){if(e.key==='Enter'&&!e.shiftKey){e.preventDefault();sendMessage();}});
</script>

</body>
</html>
