<?php
define('CHAT_FILE', 'chat.txt');
define('BACKUP_FILE', 'chat_backup.txt');
define('UPLOAD_DIR', 'uploads/');
define('STATUS_FILE', 'status.json');
define('ADMIN_PASS', 'admin123');

if (!file_exists(UPLOAD_DIR)) mkdir(UPLOAD_DIR, 0777, true);
if (!file_exists(STATUS_FILE)) file_put_contents(STATUS_FILE, json_encode([]));
if (!file_exists(CHAT_FILE)) file_put_contents(CHAT_FILE, json_encode([]));
if (!file_exists(BACKUP_FILE)) file_put_contents(BACKUP_FILE, json_encode([]));

/* ========= SAFE FILE FUNCTIONS ========= */
function safeRead($file) {
    if (!file_exists($file)) return [];
    $fp = fopen($file, 'r');
    flock($fp, LOCK_SH);
    $data = stream_get_contents($fp);
    flock($fp, LOCK_UN);
    fclose($fp);
    return json_decode($data, true) ?: [];
}
function safeWrite($file, $data) {
    $fp = fopen($file, 'w');
    flock($fp, LOCK_EX);
    fwrite($fp, json_encode($data));
    flock($fp, LOCK_UN);
    fclose($fp);
}

/* ========= DELETE MESSAGE ========= */
if (isset($_POST['delete']) && isset($_POST['user'])) {
    $user = strip_tags($_POST['user']);
    $msgIndex = intval($_POST['delete']);
    $adminPass = $_POST['admin_pass'] ?? '';
    $data = safeRead(CHAT_FILE);

    if (!isset($data[$msgIndex])) exit;
    if ($adminPass !== ADMIN_PASS && $data[$msgIndex]['user'] !== $user) {
        http_response_code(403); exit;
    }
    if (!empty($data[$msgIndex]['file']) && file_exists($data[$msgIndex]['file'])) {
        unlink($data[$msgIndex]['file']);
    }
    array_splice($data, $msgIndex, 1);
    safeWrite(CHAT_FILE, $data);
    exit;
}

/* ========= SEND MESSAGE ========= */
if (isset($_POST['user']) && !isset($_POST['status'])) {
    $user = strip_tags($_POST['user']);
    $msg = strip_tags($_POST['message'] ?? '');
    $filePath = '';

    if (isset($_FILES['file']) && $_FILES['file']['error'] == 0) {
        $filePath = UPLOAD_DIR . time() . '_' . basename($_FILES['file']['name']);
        move_uploaded_file($_FILES['file']['tmp_name'], $filePath);
    }

    if ($msg || $filePath) {
        $data = safeRead(CHAT_FILE);
        $data[] = [
            "user" => $user,
            "message" => $msg,
            "file" => $filePath,
            "time" => date("H:i"),
            "seen_by" => []
        ];
        safeWrite(CHAT_FILE, $data);

        // ذخیره همزمان در بک‌آپ
        $backup = safeRead(BACKUP_FILE);
        $backup[] = [
            "user" => $user,
            "message" => $msg,
            "file" => $filePath,
            "time" => date("H:i")
        ];
        safeWrite(BACKUP_FILE, $backup);
    }
    exit;
}

/* ========= GET MESSAGES ========= */
if (isset($_GET['get'])) {
    echo json_encode(safeRead(CHAT_FILE));
    exit;
}

/* ========= STATUS (ONLINE / TYPING) ========= */
if (isset($_POST['status'])) {
    $status = safeRead(STATUS_FILE);
    $status[$_POST['user']] = [
        "time" => time(),
        "typing" => $_POST['typing'] ?? false
    ];
    safeWrite(STATUS_FILE, $status);
    exit;
}
if (isset($_GET['status'])) {
    $status = safeRead(STATUS_FILE);
    $now = time();
    foreach ($status as $u => $s) {
        if ($now - $s['time'] > 8) unset($status[$u]);
    }
    safeWrite(STATUS_FILE, $status);
    echo json_encode($status);
    exit;
}
?>
<!DOCTYPE html>
<html lang="fa">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no, viewport-fit=cover">
<title>چت روم دلای خونی</title>
<style>
body {
    font-family: 'Tahoma', sans-serif;
    background: linear-gradient(135deg, #74ebd5 0%, #ACB6E5 100%);
    direction: rtl;
    margin: 0;
    padding: 0;
    display: flex;
    flex-direction: column;
    height: 100vh;
    overflow: hidden;
}
#loginBox, #chatBox {
    max-width: 600px;
    margin: auto;
    background: rgba(255, 255, 255, 0.95);
    border-radius: 12px;
    box-shadow: 0 4px 20px rgba(0, 0, 0, 0.2);
    padding: 20px;
    box-sizing: border-box;
}
#loginBox { text-align: center; margin: auto; }
#loginBox input {
    padding: 15px;
    width: 80%;
    font-size: 18px;
    border: 1px solid #ccc;
    border-radius: 8px;
    box-sizing: border-box;
    transition: border-color .3s;
}
#loginBox input:focus { border-color: #4caf50; outline: none; }
#loginBox button {
    padding: 15px 30px;
    margin-top: 15px;
    background: #4caf50;
    border: none;
    color: white;
    border-radius: 8px;
    cursor: pointer;
    font-size: 18px;
    transition: background-color .3s;
}
#loginBox button:hover { background: #45a049; }
#chatBox {
    display: none;
    flex-direction: column;
    height: 100%;
    padding-bottom: env(safe-area-inset-bottom);
    overflow-y: auto;
    -webkit-overflow-scrolling: touch;
}
#onlineStatus {
    font-weight: bold;
    margin-bottom: 5px;
}
#typingStatus {
    font-style: italic;
    color: #555;
    margin-bottom: 5px;
}
#chatMessages {
    flex-grow: 1;
    overflow-y: auto;
    border: 1px solid #ddd;
    padding: 15px;
    border-radius: 12px;
    background: #fff;
    word-break: break-word;
    box-shadow: inset 0 0 10px rgba(0, 0, 0, .1);
    margin-bottom: 10px;
    position: relative;
}
.message {
    margin-bottom: 12px;
    padding: 14px 22px;
    background: #ffffffcc;
    border-radius: 20px;
    position: relative;
    max-width: 80%;
    word-wrap: break-word;
    box-shadow: 0 4px 12px rgba(0, 0, 0, .12);
    border: 1px solid #d1d1d1;
    transition: background-color .3s;
}
.message:hover { background: #f1f1f1cc; }
.message.me {
    background: #dcf8c6cc;
    margin-left: auto;
    border-color: #a1d99b;
    box-shadow: 0 4px 12px rgba(0, 100, 0, .15);
}
.message .user {
    font-weight: bold;
    margin-bottom: 6px;
    font-size: 14px;
    color: #333;
}
.message .time {
    font-size: 11px;
    color: #555;
    position: absolute;
    bottom: 6px;
    left: 12px;
}
.delete-btn {
    position: absolute;
    top: 6px;
    right: 12px;
    color: #c00;
    cursor: pointer;
    font-weight: bold;
    user-select: none;
    font-size: 18px;
    transition: color .3s;
}
.delete-btn:hover { color: #a00; }
.copy-btn {
    position: absolute;
    bottom: 6px;
    left: 40px;
    cursor: pointer;
    font-size: 14px;
    color: #007bff;
    user-select: none;
    transition: color .3s;
}
.copy-btn:hover { color: #0056b3; }
#inputArea {
    display: flex;
    gap: 8px;
    flex-wrap: nowrap;
    align-items: center;
    margin-top: 10px;
}
#messageInput {
    flex-grow: 1;
    padding: 12px 16px;
    font-size: 16px;
    border-radius: 30px;
    border: 1px solid #ccc;
    box-sizing: border-box;
    transition: border-color .3s;
}
#messageInput:focus { border-color: #4caf50; outline: none; }
#fileInput { display: none; }
#fileLabel {
    font-size: 20px;
    display: flex;
    align-items: center;
    justify-content: center;
    width: 42px;
    height: 42px;
    background: #f1f1f1;
    border-radius: 50%;
    cursor: pointer;
}
#sendBtn {
    width: 42px;
    height: 42px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    background: #4caf50;
    border: none;
    cursor: pointer;
    transition: background-color .3s;
}
#sendBtn:hover { background: #45a049; }
#sendBtn svg { width: 22px; height: 22px; }
#emojiPicker { text-align: center; margin-top: 15px; }
#emojiPicker span {
    font-size: 28px;
    cursor: pointer;
    margin: 0 8px;
    user-select: none;
    transition: transform .2s;
}
#emojiPicker span:hover { transform: scale(1.3); }
#newMessageNotification {
    position: fixed;
    bottom: 10px;
    right: 10px;
    background-color: rgba(0, 123, 255, 0.8);
    color: white;
    padding: 10px 20px;
    border-radius: 10px;
    cursor: pointer;
    font-size: 16px;
    display: none;
}
@media (max-width: 640px) {
    #loginBox, #chatBox { width: 95%; padding: 15px; }
    #loginBox input, #loginBox button { width: 100%; padding: 14px; font-size: 16px; }
    #messageInput { font-size: 16px; padding: 12px 15px; }
    #emojiPicker span { font-size: 24px; margin: 0 6px; }
}
</style>
</head>
<body>
<div id="loginBox">
<h2> ورود به چت‌روم</h2>
<h3> </h3>
<input type="text" id="username" placeholder="نام کاربری...">
<br>
<input type="password" id="adminPass" placeholder="رمز ادمین (در صورت ادمین)">
<br>
<button onclick="login()">ورود</button>
</div>

<div id="chatBox">
<div id="onlineStatus"></div>
<div id="typingStatus"></div>
<div id="chatMessages"></div>

<div id="inputArea">
    <input type="text" id="messageInput" placeholder="پیام خود را بنویسید..." oninput="typing(true)" onblur="typing(false)">
    <label for="fileInput" id="fileLabel">📎</label>
    <input type="file" id="fileInput">
    <button id="sendBtn" onclick="sendMessage()">
        <svg xmlns="http://www.w3.org/2000/svg" fill="white" viewBox="0 0 24 24"><path d="M2.01 21L23 12 2.01 3 2 10l15 2-15 2z"/></svg>
    </button>
</div>

<div id="emojiPicker">
<span onclick="addEmoji('😊')">😊</span>
<span onclick="addEmoji('😂')">😂</span>
<span onclick="addEmoji('👍')">👍</span>
<span onclick="addEmoji('❤️')">❤️</span>
<span onclick="addEmoji('🔥')">🔥</span>
<span onclick="addEmoji('😢')">😢</span>
<span onclick="addEmoji('🎉')">🎉</span>
</div>
</div>

<div id="newMessageNotification" onclick="scrollToBottom()">آخرین پیام</div>

<script>
let username = '';
let adminPass = '';
let lastMessageCount = 0;
let typingTimeout = null;

function login() {
    const input = document.getElementById('username');
    const adminInput = document.getElementById('adminPass');
    username = input.value.trim();
    adminPass = adminInput.value;

    if (!username) return alert('نام کاربری را وارد کنید');
    if (adminPass && adminPass !== 'admin123') {
        alert('رمز ادمین اشتباه است!');
        return;
    }

    document.getElementById('loginBox').remove();
    document.getElementById('chatBox').style.display = 'flex';
    loadMessages();
    setInterval(loadMessages, 3000);
    setInterval(updateStatus, 3000);
    setInterval(checkStatus, 1000);
}

function addEmoji(e) {
    const i = document.getElementById('messageInput');
    i.value += e;
    i.focus();
}

function sendMessage() {
    const msgInput = document.getElementById('messageInput');
    const fileInput = document.getElementById('fileInput');
    const msg = msgInput.value.trim();
    if (!msg && !fileInput.files[0]) return;

    const formData = new FormData();
    formData.append('user', username);
    if (msg) formData.append('message', msg);
    if (fileInput.files[0]) formData.append('file', fileInput.files[0]);

    fetch('', { method: 'POST', body: formData }).then(() => {
        msgInput.value = '';
        fileInput.value = '';
        loadMessages();
    });
}

function deleteMessage(idx) {
    if (!confirm('آیا می‌خواهید این پیام را حذف کنید؟')) return;
    const formData = new URLSearchParams();
    formData.append('user', username);
    formData.append('delete', idx);
    formData.append('admin_pass', adminPass);

    fetch('', {
        method: 'POST',
        headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
        body: formData.toString()
    }).then(() => {
        // حذف مستقیم از DOM
        const msgDiv = document.querySelectorAll('.message')[idx];
        if (msgDiv) msgDiv.remove();

        // بروزرسانی شمارنده پیام‌ها
        lastMessageCount--;
    });
}


function copyMessage(id) {
    const text = document.getElementById(id).innerText;
    navigator.clipboard.writeText(text).then(() => {
        alert('پیام کپی شد!');
    }).catch(() => {
        alert('خطا در کپی کردن پیام.');
    });
}

function loadMessages() {
    fetch('?get=1')
        .then(res => res.json())
        .then(data => {
            const container = document.getElementById('chatMessages');
            const isAtBottom = container.scrollHeight - container.scrollTop <= container.clientHeight + 10;

            for (let i = lastMessageCount; i < data.length; i++) {
                const msg = data[i];
                const div = document.createElement('div');
                div.className = 'message' + (msg.user === username ? ' me' : '');
                let fileHtml = '';
                if (msg.file && msg.file.startsWith('uploads/')) {
                    const ext = msg.file.split('.').pop().toLowerCase();
                    if (['mp4','webm','ogg'].includes(ext)) {
                        fileHtml = `<div style="text-align:center; margin-top:10px;">
                            <video controls style="max-width:100%; border-radius:8px;">
                                <source src="${msg.file}" type="video/${ext}">
                                مرورگر شما از پخش ویدئو پشتیبانی نمی‌کند.
                            </video>
                            <div><a href="${msg.file}" target="_blank" style="color:#4caf50; font-weight:bold;">دانلود ویدئو</a></div>
                        </div>`;
                    } else if (['jpg','jpeg','png','gif','webp','bmp','svg'].includes(ext)) {
                        fileHtml = `<div style="text-align:center; margin-top:10px;">
                            <img src="${msg.file}" alt="image" style="max-width:100%; height:auto; border-radius:8px;"/>
                            <div><a href="${msg.file}" target="_blank" style="color:#4caf50; font-weight:bold;">دانلود تصویر</a></div>
                        </div>`;
                    } else {
                        fileHtml = `<div style="margin-top:10px; padding:12px; border:1px dashed #4caf50; border-radius:10px; text-align:center; background:#f9fff9">
                            <div style="font-size:40px;">📁</div>
                            <div style="font-weight:bold;">فایل (${ext.toUpperCase()})</div>
                            <div style="margin-top:6px;"><a href="${msg.file}" target="_blank" download style="color:#4caf50; font-weight:bold; text-decoration:none;">دانلود فایل</a></div>
                        </div>`;
                    }
                }
                div.innerHTML = `
                    <div class="user">${msg.user}</div>
                    <div class="text" id="msgText${i}">${msg.message}</div>
                    ${fileHtml}
                    <div class="time">${msg.time}</div>
                    <div class="copy-btn" onclick="copyMessage('msgText${i}')">📋</div>
                    ${ (msg.user === username || adminPass === 'admin123') ? `<div class="delete-btn" onclick="deleteMessage(${i})">×</div>` : '' }
                `;
                container.appendChild(div);
            }
            if (isAtBottom) container.scrollTop = container.scrollHeight;
            else if (data.length > lastMessageCount) document.getElementById('newMessageNotification').style.display = 'block';
            lastMessageCount = data.length;
        });
}

document.getElementById('messageInput').addEventListener('keydown', function(e) {
    if (e.key === 'Enter' && !e.shiftKey) { e.preventDefault(); sendMessage(); }
});

function scrollToBottom() {
    const container = document.getElementById('chatMessages');
    container.scrollTop = container.scrollHeight;
    document.getElementById('newMessageNotification').style.display = 'none';
}

/* ========= ONLINE / TYPING ========= */
function updateStatus(typing=false) {
    if (!username) return;
    const formData = new URLSearchParams();
    formData.append('status', 1);
    formData.append('user', username);
    if (typing) formData.append('typing', 1);
    fetch('', {method:'POST', body: formData});
}

function typing(isTyping) {
    updateStatus(isTyping);
    if (typingTimeout) clearTimeout(typingTimeout);
    if (isTyping) typingTimeout = setTimeout(()=>updateStatus(false), 2000);
}

function checkStatus() {
    fetch('?status=1').then(res=>res.json()).then(data=>{
        const onlineUsers = Object.keys(data);
        document.getElementById('onlineStatus').innerHTML = `🟢 آنلاین: ${onlineUsers.length}`;
        let typingUsers = onlineUsers.filter(u => data[u].typing && u!==username);
        document.getElementById('typingStatus').innerHTML = typingUsers.length ? `${typingUsers.join(', ')} در حال تایپ...` : '';
    });
}
</script>
</body>
</html>
