<?php
declare(strict_types=1);

return [
  // SQLite database file (created automatically)
  'db_path' => __DIR__ . '/data.sqlite',

  // Where uploaded audio files are stored
  'upload_dir' => __DIR__ . '/uploads',

  // Public URL path for uploads (relative to project root)
  'base_url_uploads' => 'uploads',

  // Max upload size in MB
  'max_upload_mb' => 50,

  // Allowed MIME types (depends on server/file; we also validate extension)
  'allowed_mime' => [
    'audio/mpeg',      // mp3
    'audio/mp4',       // m4a
    'audio/x-m4a',
    'audio/wav',
    'audio/x-wav',
    'audio/ogg',
    'application/octet-stream', // some servers report this for audio; extension check still applies
  ],

  // Allowed extensions (lowercase, without dot)
  'allowed_ext' => ['mp3', 'm4a', 'wav', 'ogg'],
];
