<?php
declare(strict_types=1);

// Auto-init DB on first run
$cfg = require __DIR__ . '/config.php';
if (!file_exists($cfg['db_path'])) {
  require __DIR__ . '/init_db.php';
}
?><!doctype html>
<html lang="fa" dir="rtl">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1, viewport-fit=cover" />
  <title>iPhone Style Music Player (PHP + SQLite)</title>
  <link rel="stylesheet" href="assets/style.css" />
</head>
<body>
  <div class="app">
    <header class="topbar">
      <div class="topbar-left">
        <div class="pill">🎵 Player</div>
      </div>
      <div class="topbar-right">
        <button class="icon-btn" id="btnUploadOpen" title="آپلود">⤴︎</button>
        <button class="icon-btn" id="btnRefresh" title="تازه‌سازی">⟲</button>
      </div>
    </header>

    <main class="content">
      <section class="card">
        <div class="card-title">پخش‌کننده</div>
        <div class="now">
          <div class="cover" aria-hidden="true"></div>
          <div class="meta">
            <div class="t" id="nowTitle">—</div>
            <div class="a" id="nowArtist">—</div>
          </div>
        </div>

        <div class="controls">
          <button class="ctrl" id="btnPrev" title="قبلی">⟨⟨</button>
          <button class="ctrl main" id="btnPlay" title="پخش/مکث">▶︎</button>
          <button class="ctrl" id="btnNext" title="بعدی">⟩⟩</button>
        </div>

        <div class="seek">
          <span class="time" id="tCur">0:00</span>
          <input type="range" id="seek" min="0" max="100" value="0" />
          <span class="time" id="tDur">0:00</span>
        </div>

        <div class="vol">
          <span>صدا</span>
          <input type="range" id="vol" min="0" max="1" step="0.01" value="0.9" />
        </div>

        <audio id="audio" preload="metadata"></audio>
      </section>

      <section class="grid">
        <section class="card">
          <div class="card-head">
            <div class="card-title">کتابخانه</div>
            <div class="actions">
              <input class="search" id="search" placeholder="جستجو (عنوان/هنرمند/آلبوم)..." />
            </div>
          </div>
          <div class="list" id="trackList"></div>
        </section>

        <section class="card">
          <div class="card-head">
            <div class="card-title">پلی‌لیست‌ها</div>
            <div class="actions">
              <button class="btn" id="btnNewPlaylist">+ جدید</button>
            </div>
          </div>

          <div class="split">
            <div class="playlists" id="playlistList"></div>
            <div class="playlist-items">
              <div class="mini-title" id="plTitle">—</div>
              <div class="list" id="playlistItems"></div>
            </div>
          </div>
        </section>
      </section>
    </main>

    <!-- Upload Sheet -->
    <div class="sheet-backdrop" id="uploadBackdrop" hidden></div>
    <div class="sheet" id="uploadSheet" hidden>
      <div class="sheet-handle" aria-hidden="true"></div>
      <div class="sheet-title">آپلود آهنگ</div>
      <form id="uploadForm">
        <input type="file" id="file" name="file" accept="audio/*" required />
        <button class="btn primary" type="submit">آپلود</button>
        <div class="progress" id="uploadProgress" hidden>
          <div class="bar" id="uploadBar"></div>
        </div>
        <div class="hint" id="uploadHint">فرمت‌های رایج: mp3 / m4a / wav / ogg</div>
      </form>
      <button class="btn ghost" id="btnUploadClose">بستن</button>
    </div>

    <!-- Toast -->
    <div class="toast" id="toast" hidden></div>
  </div>

  <script src="assets/app.js"></script>
</body>
</html>
